<?php

chdir("..");

// DEFINE SE PAGE CONSTANT
define('SE_PAGE', TRUE);

if (!function_exists('json_encode')) {
  function json_encode($a=false)
  {
    if (is_null($a)) return 'null';
    if ($a === false) return 'false';
    if ($a === true) return 'true';
    if (is_scalar($a))
    {
      if (is_float($a))
      {
        // Always use "." for floats.
        return floatval(str_replace(",", ".", strval($a)));
      }

      if (is_string($a))
      {
        static $jsonReplaces = array(array("\\", "/", "\n", "\t", "\r", "\b", "\f", '"'), array('\\\\', '\\/', '\\n', '\\t', '\\r', '\\b', '\\f', '\"'));
        return '"' . str_replace($jsonReplaces[0], $jsonReplaces[1], $a) . '"';
      }
      else
        return $a;
    }
    $isList = true;
    for ($i = 0, reset($a); $i < count($a); $i++, next($a))
    {
      if (key($a) !== $i)
      {
        $isList = false;
        break;
      }
    }
    $result = array();
    if ($isList)
    {
      foreach ($a as $v) $result[] = json_encode($v);
      return '[' . join(',', $result) . ']';
    }
    else
    {
      foreach ($a as $k => $v) $result[] = json_encode($k).':'.json_encode($v);
      return '{' . join(',', $result) . '}';
    }
  }
}

if (!function_exists('shout_htmlspecialchars')) {
	function shout_htmlspecialchars($s) {
		return htmlspecialchars($s, ENT_QUOTES);
	}
}

if (!function_exists('shout_truncate')) {
	function shout_truncate($string, $max = 20, $replacement = '') {
		if (strlen($string) <= $max)
		{
			return $string;
		}
		$leave = $max - strlen ($replacement);
		return substr_replace($string, $replacement, $leave);
	}
}

function shout_hyperlink(&$text) {
      $text = preg_replace('@((https?:)?//([-\w\.]+)+(:\d+)?(/([\w/_\.]*(\?\S+)?)?)?)@', '<a href="$1" target="_blank">$1</a>', $text);
   
      $text = preg_replace("/\s(www\.([a-z][a-z0-9_\..-]*[a-z]{2,6})([a-zA-Z0-9\/*-?&%]*))\s/i", " <a href=\"http://$1\" target=\"_blank\">$1</a> ", $text);
      $text = preg_replace("/^(www\.([a-z][a-z0-9_\..-]*[a-z]{2,6})([a-zA-Z0-9\/*-?&%]*))\s/i", "<a href=\"http://$1\" target=\"_blank\">$1</a> ", $text);
      $text = preg_replace("/\s(www\.([a-z][a-z0-9_\..-]*[a-z]{2,6})([a-zA-Z0-9\/*-?&%]*))$/i", " <a href=\"http://$1\" target=\"_blank\">$1</a>", $text);
      $text = preg_replace("/^(www\.([a-z][a-z0-9_\..-]*[a-z]{2,6})([a-zA-Z0-9\/*-?&%]*))$/i", "<a href=\"http://$1\" target=\"_blank\">$1</a>", $text);
     
      return $text;
}

include "header.php";

// GET SHOUTBOX SETTINGS	
$shoutbox_settings = $database->database_fetch_assoc($database->database_query("SELECT * FROM se_shout_settings LIMIT 1"));

// USER IS LOGGED IN
$serve_shouts=0;
if($user->user_exists != 0) $serve_shouts=1;
if ($shoutbox_settings['shout_setting_shouts_public'] == 1) $serve_shouts=1;

if($serve_shouts != 0) { 	
	$user_settings = $database->database_fetch_assoc($database->database_query("SELECT * FROM se_usersettings WHERE usersetting_user_id='".$user->user_info[user_id]."' LIMIT 1"));

	// Add new message, if posted
	$action = $_REQUEST['action'];
	$message = censor(strip_tags($_REQUEST['message']));
	// HTML encode
	$message = htmlspecialchars($message, ENT_QUOTES);
	
	if ($action === "postmsg") {
		$userID = $user->user_info[user_id];
		$timeNow = time();
		if (strlen($message) >= $shoutbox_settings['shout_setting_min_msg_length']) {
			// Flood check, at least 1 minute between posts
			$lastShoutThisUser = $database->database_fetch_assoc($database->database_query("SELECT shout_time FROM se_shouts WHERE shout_user_id='$userID' ORDER BY shout_time DESC LIMIT 1"));
			if ($timeNow - $lastShoutThisUser['shout_time'] > $shoutbox_settings['shout_setting_flood_time']) {
				// Insert shout
				$database->database_query("INSERT INTO se_shouts SET shout_user_id='$userID', shout_msg='$message', shout_time='$timeNow'");
			}
		}
	}
	
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT" ); 
	header("Last-Modified: " . gmdate( "D, d M Y H:i:s" ) . "GMT" ); 
	header("Cache-Control: no-cache, must-revalidate" ); 
	header("Pragma: no-cache" );
	header("Content-Type: text/xml; charset=utf-8");
	
	$timeStamp = $_REQUEST['lastShoutTime'];
	$maxShouts = $_REQUEST['maxShouts'];
	
	$filterSetting = $user_settings['usersetting_shoutbox_filter'];
				
	if ($filterSetting == 0) {  // All shouts
		$newShoutsQueryResult = $database->database_query("SELECT se_shouts.shout_id, se_shouts.shout_user_id,se_shouts.shout_msg,se_shouts.shout_time,se_users.user_username, se_users.user_fname,se_users.user_lname, se_users.user_photo FROM se_shouts JOIN se_users ON se_shouts.shout_user_id=se_users.user_id WHERE shout_time > $timeStamp ORDER BY shout_time DESC LIMIT $maxShouts");
	} else if ($filterSetting == 1) {  // Only friends shouts
		$newShoutsQueryResult = $database->database_query("SELECT s1.shout_id, s1.shout_user_id,s1.shout_msg,s1.shout_time,se_users.user_username, se_users.user_fname,se_users.user_lname, se_users.user_photo FROM se_shouts s1 JOIN se_users ON s1.shout_user_id=se_users.user_id WHERE shout_time > $timeStamp AND (EXISTS (SELECT * FROM se_friends WHERE friend_user_id1='".$user->user_info[user_id]."' AND friend_user_id2=s1.shout_user_id) OR s1.shout_user_id='".$user->user_info[user_id]."') ORDER BY s1.shout_time DESC LIMIT $maxShouts");	
	}
	$newShouts = array();
	while ($newShout = $database->database_fetch_assoc($newShoutsQueryResult)) {
		$newShouts[] = $newShout;
	}
	
	$newShouts = array_reverse($newShouts);
	$newTimeStamp = time();

	$arr = array();
	if (sizeof($newShouts) > 0) foreach ($newShouts as $shout) {
		$shout['timeStamp'] = $newTimeStamp;

		$fullname = $shout['user_fname'].((trim($shout['user_fname']) != "" && trim($shout['user_lname']) != "") ? " " : "").$shout['user_lname'];
		$user_displayname = (trim($fullname) != "") ? $fullname : $shout['user_username'];

		if ($setting['setting_username'] == 1) {
			$profile_page = "profile.php?user=".$shout['user_username'];
		} else {		
			$profile_page = "/".$shout['user_username'];
		}
		$shout['profile_page'] = $profile_page;
		$shout['displayname'] = shout_truncate($user_displayname,20,'...');
		
		$photo_arr = explode(".",$shout['user_photo']);
		$photo_ext = array_pop($photo_arr);
		$photo_thumb = implode(".",$photo_arr)."_thumb.".$photo_ext;
		$subdir = $shout['shout_user_id']+999-(($shout['shout_user_id']-1)%1000);
	    $userdir = "./uploads_user/$subdir/".$shout['shout_user_id']."/";
		if (strlen($shout['user_photo']) == 0) {
			$shout['profile_pic'] =  "images/nophoto.gif";
		} else {
			$shout['profile_pic'] =  $userdir.$photo_thumb;		
		}
		$shout['shout_msg'] = htmlspecialchars_decode($shout['shout_msg'], ENT_QUOTES);
		//$shout['shout_msg'] = str_replace('/','/<wbr/>',$shout['shout_msg']);
//		$shout['shout_msg'] = preg_replace("/([^\s]{10}|\/|\.)/","$1<wbr/>",$shout['shout_msg']);
//		$shout['shout_msg'] = preg_replace("/[\s\`](([a-zA-Z]+:\/\/)([a-zA-Z0-9\/*-?&%]*))[\s\Z]/i", " <a href=\"$1\">$1</a> ",$shout['shout_msg']);
		$shout['shout_msg'] = shout_hyperlink($shout['shout_msg']);
//		$shout_tmp_arr = mb_str_split(htmlspecialchars_decode($shout['shout_msg'], ENT_QUOTES),10);
//		$shout['shout_msg'] = implode("<wbr/>", array_map("shout_htmlspecialchars",$shout_tmp_arr));
		$arr[]=$shout;
	}
	
	echo json_encode($arr);


} 
?>
