<?

if ($page === "user_home" || $page === "user_shoutbox_history" || $page === "home") {
	if (!function_exists('json_encode')) {
	  function json_encode($a=false)
	  {
		if (is_null($a)) return 'null';
		if ($a === false) return 'false';
		if ($a === true) return 'true';
		if (is_scalar($a))
		{
		  if (is_float($a))
		  {
			// Always use "." for floats.
			return floatval(str_replace(",", ".", strval($a)));
		  }
	
		  if (is_string($a))
		  {
			static $jsonReplaces = array(array("\\", "/", "\n", "\t", "\r", "\b", "\f", '"'), array('\\\\', '\\/', '\\n', '\\t', '\\r', '\\b', '\\f', '\"'));
			return '"' . str_replace($jsonReplaces[0], $jsonReplaces[1], $a) . '"';
		  }
		  else
			return $a;
		}
		$isList = true;
		for ($i = 0, reset($a); $i < count($a); $i++, next($a))
		{
		  if (key($a) !== $i)
		  {
			$isList = false;
			break;
		  }
		}
		$result = array();
		if ($isList)
		{
		  foreach ($a as $v) $result[] = json_encode($v);
		  return '[' . join(',', $result) . ']';
		}
		else
		{
		  foreach ($a as $k => $v) $result[] = json_encode($k).':'.json_encode($v);
		  return '{' . join(',', $result) . '}';
		}
	  }
	}
	
	if (!function_exists('shout_htmlspecialchars')) {
		function shout_htmlspecialchars($s) {
			return htmlspecialchars($s, ENT_QUOTES);
		}
	}
	
	if (!function_exists('shout_truncate')) {
		function shout_truncate($string, $max = 20, $replacement = '') {
			if (strlen($string) <= $max)
			{
				return $string;
			}
			$leave = $max - strlen ($replacement);
			return substr_replace($string, $replacement, $leave);
		}
	}
	
	// ENSURE THIS IS BEING INCLUDED IN AN SE SCRIPT
	if(!defined('SE_PAGE')) { exit(); }
	
	// USER IS LOGGED IN
	//if($user->user_exists != 0) { 	
		$shoutbox_settings = $database->database_fetch_assoc($database->database_query("SELECT * FROM se_shout_settings LIMIT 1"));
		$user_settings = $database->database_fetch_assoc($database->database_query("SELECT * FROM se_usersettings WHERE usersetting_user_id='".$user->user_info[user_id]."' LIMIT 1"));
	
		// Add new message, if posted
		$task = $_REQUEST['task'];
		$message = strip_tags($_REQUEST['shoutbox_msg']);
		// HTML encode
		$message = htmlspecialchars($message, ENT_QUOTES);
		
		$userID = $user->user_info[user_id];
		$timeNow = time();
		// Flood check, at least 1 minute between posts
		$lastShoutThisUser = $database->database_fetch_assoc($database->database_query("SELECT shout_time FROM se_shouts WHERE shout_user_id='$userID' ORDER BY shout_time DESC LIMIT 1"));
		if ($task === "post_shout") {
			if (strlen($message) >= $shoutbox_settings['shout_setting_min_msg_length']) {
				if ($timeNow - $lastShoutThisUser['shout_time'] > $shoutbox_settings['shout_setting_flood_time']) {
					// Insert shout
					$database->database_query("INSERT INTO se_shouts SET shout_user_id='$userID', shout_msg='$message', shout_time='$timeNow'");
				}
			} 
			$shoutAllowed = 0;
			$timeToNextShout = $shoutbox_settings['shout_setting_flood_time'];
		} else {
			$timeToNextShout = $shoutbox_settings['shout_setting_flood_time'] - ($timeNow - $lastShoutThisUser['shout_time']);
			if ($timeToNextShout >= 0) {
				$shoutAllowed = 0;
			} else {
				$shoutAllowed = 1;	
			}
		}
			
		$timeStamp = 0;
		$maxShouts = $shoutbox_settings['shout_setting_num_shouts'];
		
		$filterSetting = $user_settings['usersetting_shoutbox_filter'];
					
		if ($filterSetting == 0) {  // All shouts
			$newShoutsQueryResult = $database->database_query("SELECT se_shouts.shout_id, se_shouts.shout_user_id,se_shouts.shout_msg,se_shouts.shout_time,se_users.user_username, se_users.user_fname,se_users.user_lname, se_users.user_photo FROM se_shouts JOIN se_users ON se_shouts.shout_user_id=se_users.user_id WHERE shout_time > $timeStamp ORDER BY shout_time DESC LIMIT $maxShouts");
		} else if ($filterSetting == 1) {  // Only friends shouts
			$newShoutsQueryResult = $database->database_query("SELECT s1.shout_id, s1.shout_user_id,s1.shout_msg,s1.shout_time,se_users.user_username, se_users.user_fname,se_users.user_lname, se_users.user_photo FROM se_shouts s1 JOIN se_users ON s1.shout_user_id=se_users.user_id WHERE shout_time > $timeStamp AND (EXISTS (SELECT * FROM se_friends WHERE friend_user_id1='".$user->user_info[user_id]."' AND friend_user_id2=s1.shout_user_id) OR s1.shout_user_id='".$user->user_info[user_id]."') ORDER BY s1.shout_time DESC LIMIT $maxShouts");	
		}
		$newShouts = array();
		while ($newShout = $database->database_fetch_assoc($newShoutsQueryResult)) {
			$newShouts[] = $newShout;
		}
		
		//$newShouts = array_reverse($newShouts);
		$newTimeStamp = time();
	
		$arr = array();
		if (sizeof($newShouts) > 0) foreach ($newShouts as $shout) {
			$shout['timeStamp'] = $newTimeStamp;
	
			$fullname = $shout['user_fname'].((trim($shout['user_fname']) != "" && trim($shout['user_lname']) != "") ? " " : "").$shout['user_lname'];
			$user_displayname = (trim($fullname) != "") ? $fullname : $shout['user_username'];
	
			if ($setting['setting_username'] == 1) {
				$profile_page = "profile.php?user=".$shout['user_username'];
			} else {		
				$profile_page = "/".$shout['user_username'];
			}
			$shout['profile_page'] = $profile_page;
			$shout['displayname'] = shout_truncate($user_displayname,20,'...');
			$photo_arr = explode(".",$shout['user_photo']);
			$photo_ext = array_pop($photo_arr);
			$photo_thumb = implode(".",$photo_arr)."_thumb.".$photo_ext;
			if (strlen($shout['user_photo']) == 0) {
				$shout['profile_pic'] =  "images/nophoto.gif";
			} else {
				$shout['profile_pic'] =  $url->url_userdir($shout['shout_user_id']).$photo_thumb;		
			}
			$shout_tmp_arr = str_split(htmlspecialchars_decode($shout['shout_msg'], ENT_QUOTES),10);
			$shout['shout_msg'] = implode("<wbr/>", array_map("shout_htmlspecialchars",$shout_tmp_arr));
	//		$shout['shout_msg'] = implode("<wbr/>", str_split($shout['shout_msg'],10));
			$arr[]=$shout;
		}
	//} 
	
	$smarty->assign('shouts', $arr);
	$smarty->assign('shout_allowed', $shoutAllowed);
	$smarty->assign('shout_time2next', $timeToNextShout);
	$smarty->assign('shout_setting_flood_time', $shoutbox_settings['shout_setting_flood_time']);
	$smarty->assign('shout_setting_min_msg_length', $shoutbox_settings['shout_setting_min_msg_length']);
	$smarty->assign('shout_setting_num_shouts', $shoutbox_settings['shout_setting_num_shouts']);
	$smarty->assign('shout_setting_poll_time', $shoutbox_settings['shout_setting_poll_time']);
	$smarty->assign('shout_setting_highlight_time', $shoutbox_settings['shout_setting_highlight_time']);
	$smarty->assign('shout_setting_enable_prefs', $shoutbox_settings['shout_setting_enable_prefs']);
	$smarty->assign('shout_setting_from_top', $shoutbox_settings['shout_setting_from_top']);
	$smarty->assign('shout_setting_user_photo', $shoutbox_settings['shout_setting_user_photo']);
	$smarty->assign('shout_setting_default_height', $shoutbox_settings['shout_setting_default_height']);
	$smarty->assign('shout_setting_shouts_public', $shoutbox_settings['shout_setting_shouts_public']);
	
}
?>