/*
 * Shoutbox by Flemming Hansen (http://www.vinlandtech.com)
 *
 * Copyright 2008. All rights reserved.
 * This is commercial software, not to be distributed except with the authors specific permission.
 *
 */
jQuery.noConflict();

var lastShoutTime = 0;
var lastShoutID = 0;
var shoutTimes = [];
var nextShoutCnt = 0;
var timeDiffComp = 0;
function loadShouts() {
	var nowTimestamp = new Date().getTime();
	jQuery.getJSON("ajax/json_shouts.php",{lastShoutTime: lastShoutTime, maxShouts: numShouts, dummyTimeStamp: nowTimestamp}, function(data) {
		var returnTimestamp = Math.round(new Date().getTime()/1000.0);
		if (data.length > 0) {
				timeDiffComp = data[0].timeStamp - returnTimestamp;
		}
		addShouts(data,timeDiffComp);
	});
	setTimeout(loadShouts,newShoutCheckInterval);
}

function ago(difference){
    var periods_singular = [SELanguage.Translate(27000117), SELanguage.Translate(27000118), SELanguage.Translate(27000119), SELanguage.Translate(27000120)];
    var periods_plural = [SELanguage.Translate(27000121), SELanguage.Translate(27000122), SELanguage.Translate(27000123), SELanguage.Translate(27000124)];
    var lengths = ["60","60","24"];
    for(var j = 0; difference >= lengths[j]; j++) {
      difference /= lengths[j];
	}
    difference = Math.round(difference);
    if(difference != 1) {
    	text = SELanguage.Translate(27000126)+difference+" "+periods_plural[j]+SELanguage.Translate(27000127);
	} else {
    	text = SELanguage.Translate(27000126)+difference+" "+periods_singular[j]+SELanguage.Translate(27000127);		
	}
    return text;
}

function updateAgos() {
	var nowTimestamp = Math.round(new Date().getTime()/1000.0);
	for (var i=0; i<shoutTimes.length; i++) {
		jQuery("#shout_ago"+i).html(ago(nowTimestamp - shoutTimes[i]));
		if (nowTimestamp - shoutTimes[i] < highlightNewTime) {
			if (shoutUserPhoto == 1)  {
				jQuery("#shout_ago"+i).parent().parent().addClass('shout_highlight');
			} else {
				jQuery("#shout_ago"+i).parent().addClass('shout_highlight');
			}
		} else {
			if (shoutUserPhoto == 1)  {
				jQuery("#shout_ago"+i).parent().parent().removeClass('shout_highlight');
			} else {
				jQuery("#shout_ago"+i).parent().removeClass('shout_highlight');
			}
		}
	}
	setTimeout(updateAgos,1000);	
}

function expandShouts(animSpeed) {
	if (animSpeed == null) animSpeed=2000;
	if (jQuery.browser.safari) {
		jQuery('#shoutlist').css('overflow','');
	}
	var targetHeight = jQuery('#shoutbox_wrapper').attr('scrollHeight');
	jQuery('#expandLink').hide();
	jQuery('#shrinkLink').show();
	jQuery('#shoutbox_wrapper').animate({height: targetHeight, scrollTop: 0},animSpeed);
}

function shrinkShouts(animSpeed) {
	if (animSpeed == null) animSpeed=2000;
	jQuery('#expandLink').show();
	jQuery('#shrinkLink').hide();
	jQuery('#shoutbox_wrapper').animate({height: shoutboxDefaultHeight, scrollTop: 0},animSpeed, 'linear', function() {
		if (addFromTop == 0) {
			var targetOffset = jQuery('#shoutbox_wrapper').attr('scrollHeight');
			jQuery('#shoutbox_wrapper').animate({scrollTop: targetOffset},animSpeed);
		}
		if (jQuery.browser.safari) {
			jQuery('#shoutlist').css('overflow','hidden');
		}
	});
}

function showNewShout() {
	jQuery("#newshout").slideDown();
	jQuery("#newshout_link").slideUp();	
}

function hideNewShout() {
	jQuery("#newshout").slideUp();
	jQuery("#newshout_link").slideDown();	
}

function doNextShoutTimeout() {
	jQuery("#newshout").slideUp();
	jQuery("#newshout_cnt").slideDown();	
	nextShoutCnt = nextShoutDelay;
	shoutCnt();
}

function completeNextShoutTimeout() {
	jQuery("#newshout_cnt").slideUp();	
	jQuery("#newshout_link").slideDown();
}

function shoutCnt() {
	jQuery("#shoutcnt").html(""+nextShoutCnt);
	if (nextShoutCnt === 0) {
		completeNextShoutTimeout();
	} else {
		nextShoutCnt--;
		setTimeout(shoutCnt,1000);	
	}
}

function addShouts(data,timeComp) {
	if (lastShoutTime === 0) {
		jQuery("#shoutlist").html("");
	}
	var alt=0;
	var photo="";
	if (data.length > 0) {
		for (var i=0; i < data.length; i++) {
			photo="";
			alt=alt==1?0:1;
			if (data[i].shout_id != lastShoutID) {
				if (shoutUserPhoto == 1) {
					photo = "<img src='"+data[i].profile_pic+"' width='60px' height='60px'>";
					if (addFromTop == 0) {
						jQuery("#shoutlist").append("<div class='shout_div"+alt+"'><div class='shout_nameago'><a href='"+data[i].profile_page+"'>"+data[i].displayname+"</a><span class='shout_ago2' id='shout_ago"+shoutTimes.length+"'></span></div><div class='shout_pic'>"+photo+"</div><p class='shout_msg'>"+data[i].shout_msg+"</p></div>");
					} else {
						jQuery("#shoutlist").prepend("<div class='shout_div"+alt+" fresh_shout' style='display:none'><div class='shout_nameago'><a href='"+data[i].profile_page+"'>"+data[i].displayname+"</a><span class='shout_ago2' id='shout_ago"+shoutTimes.length+"'></span></div><div class='shout_pic'>"+photo+"</div><p class='shout_msg'>"+data[i].shout_msg+"</p></div>");
					}
				} else {
					if (addFromTop == 0) {
						jQuery("#shoutlist").append("<div class='shout_div"+alt+"'><span class='shout_name'><a href='"+data[i].profile_page+"'>"+data[i].displayname+"</a></span><span class='shout_ago' id='shout_ago"+shoutTimes.length+"'></span><p class='shout_msg'>"+data[i].shout_msg+"</p></div>");
					} else {
						jQuery("#shoutlist").prepend("<div class='shout_div"+alt+" fresh_shout' style='display:none'><span class='shout_name'><a href='"+data[i].profile_page+"'>"+data[i].displayname+"</a></span><span class='shout_ago' id='shout_ago"+shoutTimes.length+"'></span><p class='shout_msg'>"+data[i].shout_msg+"</p></div>");
					}
				}
				lastShoutTime = data[i].timeStamp;
				lastShoutID = data[i].shout_id;
				shoutTimes.push(parseInt(data[i].shout_time, 10)-timeComp);	
			}
		}
		if (addFromTop == 0) {
			var targetOffset = jQuery('#shoutbox_wrapper').attr('scrollHeight');
			jQuery('#shoutbox_wrapper').animate({scrollTop: targetOffset},2000);
		} else {
			if (jQuery.browser.safari) {
				if (jQuery('#shrinkLink').is(":visible")) {
					var targetHeight = jQuery('#shoutbox_wrapper').attr('scrollHeight');
					jQuery('#shoutbox_wrapper').animate({height: targetHeight, scrollTop: 0},0, 'linear', function() {
						var targetHeight = jQuery('#shoutbox_wrapper').attr('scrollHeight');
						jQuery('#shoutbox_wrapper').animate({height: targetHeight, scrollTop: 0},0);
					});
				}
			}
			jQuery('.fresh_shout').slideDown();
			jQuery('.fresh_shout').removeClass('fresh_shout');			
		}
	}
}

jQuery(document).ready(function() {
	jQuery('#shoutlist').html('<img src="images/shout-loader.gif" />');
	jQuery('#newshout_link').show();
	jQuery('#newshout_cnt_nonjs').hide();
	jQuery('#expandLink').show();
	jQuery('#newshout').hide();
	jQuery('#shoutbox_wrapper').css('overflow', 'hidden');
	jQuery('#shoutlist').css('height', shoutboxDefaultHeight);
	if (jQuery.browser.safari) {
		jQuery('#shoutlist').css('overflow','hidden');
	}

	// Fix for Safari not supporting scrollHeight attribute
	if (jQuery.browser.safari) {
		addFromTop = 1;	
	}
	
	//textarea_autogrow('shoutbox_msg');	
	
	loadShouts();
	var targetHeight = jQuery('#shoutbox_wrapper').attr('scrollHeight');
	jQuery('#shoutbox_wrapper').animate({height: targetHeight, scrollTop: 0},2000);
	updateAgos();
	
	jQuery("form#shoutbox_form").validate({
		rules: {
			shoutbox_msg: {
				required: true,
				minlength: minMsgLength

			}
		},
		messages: {
			shoutbox_msg: {
				required: SELanguage.Translate(27000128),
				minlength: SELanguage.Translate(27000129)
			}
		}
	});

	jQuery("form#shoutbox_form").submit(function(){
		if (jQuery("form#shoutbox_form").valid()) {

			jQuery.getJSON("ajax/json_shouts.php",{
			   message: jQuery("#shoutbox_msg").val(),
			   action: "postmsg",
			   lastShoutTime: lastShoutTime,
			   maxShouts: numShouts
			 }, function(data) {
					jQuery("#shoutbox_msg").val("");
					doNextShoutTimeout();
					var returnTimestamp = Math.round(new Date().getTime()/1000.0);
					if (data.length > 0) {
						timeDiffComp = data[0].timeStamp - returnTimestamp;
					}
					addShouts(data,timeDiffComp);
				 }
			);
		}
		return false;
	});
});

