{include file='header.tpl'}

{lang_javascript ids=27000128,27000129}
{literal}
<script type="text/javascript" src="include/js/jquery.min.js"></script>
<script type="text/javascript" src="include/js/jquery.form.js"></script>
<script type="text/javascript" src="include/js/jquery.autogrow.js"></script>
<script type="text/javascript" src="include/js/jquery.validate.min.js"></script>
<script type="text/javascript">
{/literal}
var minMsgLength = {$shout_setting_min_msg_length};
{literal}

jQuery.noConflict();

function showNewShout() {
	jQuery("#newshout").slideDown();
	jQuery("#newshout_link").slideUp();	
}

function hideNewShout() {
	jQuery("#newshout").slideUp();
	jQuery("#newshout_link").slideDown();	
}

jQuery(document).ready(function() {
	jQuery('#newshout_link').show();
	jQuery('#expandLink').show();
	jQuery('#newshout').hide();

	textarea_autogrow('shoutbox_msg');	
		
	jQuery("form#shoutbox_form").validate({
		rules: {
			shoutbox_msg: {
				required: true,
				minlength: minMsgLength

			}
		},
		messages: {
			shoutbox_msg: {
				required: SELanguage.Translate(27000128),
				minlength: SELanguage.Translate(27000129)
			}
		}
	});

	jQuery("form#shoutbox_form").submit(function(){
		if (jQuery("form#shoutbox_form").valid()) {

			jQuery.getJSON("ajax/json_shouts.php",{
			   message: jQuery("#shoutbox_msg").val(),
			   action: "postmsg",
			   lastShoutTime: lastShoutTime,
			   maxShouts: numShouts
			 }, function(data) {
					jQuery("#shoutbox_msg").val("");
					doNextShoutTimeout();
					var returnTimestamp = Math.round(new Date().getTime()/1000.0);
					if (data.length > 0) {
						timeDiffComp = data[0].timeStamp - returnTimestamp;
					}
					addShouts(data,timeDiffComp);
				 }
			);
		}
		return false;
	});
});

</script>
<style type="text/css">
.example{color:#888;}
textarea{
	min-height:40px;
	min-width:300px;
	overflow:auto;
}
label.error {
	margin-left: 10px;
	width: auto;
	display: inline;
	color: red;
}
/* Shoutbox CSS */
.shout_div0 td {
	border-bottom: dotted 1px #CCCCCC;
}
td.shout_ago {
	text-align:right;
}
td.shout_pic {
	padding-top: 4px;
	text-align:center;
	width: 80px;
}
span.shout_name{
	float:left;
	clear:left;
	display:block;
}
td.shout_ago{
	color: #999999;
	padding-left: 5px;
	vertical-align:top;
}
td.shout_msg {
	padding-left: 12px;
}
.shout_highlight {
	background: #DDFFDD;
}
.shoutbox_pref_link {
	width: 50%; 
	float: right; 
	text-align: right; 
	padding-top: 8px;
}
</style>
{/literal}

<table width='100%'><tr>
<td valign="top"><div class='page_header'>{lang_print id=27000130}</div>
{if $user->user_exists == 1}
	<div id="newshout_link" style="display:none"><a href='javascript:;' onclick="showNewShout()"><img class='icon' border='0' src='images/icons/shoutbox16.gif' />{lang_print id=27000113}</a></div>
{/if}
</td><td style='text-align: right'>

{if $user->user_exists == 1}
	<div id="newshout" {if $shout_allowed == 0}style="display:none"{/if}>
	<form id="shoutbox_form" method="post" action="user_shoutbox_history.php">
	<input type="hidden" name="action" value="postmsg"  />
	<textarea id="shoutbox_msg" name="shoutbox_msg" title="{lang_print id=27000131}" ></textarea><br />
	{lang_print id=27000132}<br/>
	<input type="submit" value="{lang_print id=27000133}" class="button"/>&nbsp;&nbsp;<input type="button" class="button" value="{lang_print id=27000134}" onClick="hideNewShout()"/><br />
	</form>
	</div>
{/if}
</td>
</tr></table>
{* DISPLAY PAGINATION MENU IF APPLICABLE *}
{if $maxpage > 1}
  <div class='center'>
  {if $p != 1}<a href='user_shoutbox_history.php?p={math equation='p-1' p=$p}'>&#171; {lang_print id=182}</a>{else}<font class='disabled'>&#171; {lang_print id=182}</font>{/if}
  {if $p_start == $p_end}
    &nbsp;|&nbsp; {lang_sprintf id=184 1=$p_start 2=$total_shouts} &nbsp;|&nbsp; 
  {else}
    &nbsp;|&nbsp; {lang_sprintf id=185 1=$p_start 2=$p_end 3=$total_shouts} &nbsp;|&nbsp; 
  {/if}
  {if $p != $maxpage}<a href='user_shoutbox_history.php?p={math equation='p+1' p=$p}'>{lang_print id=183} &#187;</a>{else}<font class='disabled'>{lang_print id=183} &#187;</font>{/if}
  </div>
<br>
{/if}


<table width="100%">
{* DISPLAY SHOUTS *}
{if $shoutUserPhoto == 1}
	{section name=shouts_loop loop=$shouts}
	<tr class='shout_div0' >
    {assign var='action_date' value=$datetime->time_since($shouts[shouts_loop].shout_time)}
	<td class='shout_pic'><img src='{$shouts[shouts_loop].profile_pic}' width='60px' height='60px'><br/><a href='{$shouts[shouts_loop].profile_page}'>{$shouts[shouts_loop].displayname}</a></td><td class='shout_msg'>{$shouts[shouts_loop].shout_msg}</td><td class='shout_ago'><span class='shout_ago2'>{lang_sprintf id=$action_date[0] 1=$action_date[1]}</span></td>
	{if $shout_moderator == 1}
	<td>
	<form action="user_shoutbox_history.php" method="post">
	<input type="hidden" name='task' value='delete_shout' />
	<input type="hidden" name='shout_id' value='{$shouts[shouts_loop].shout_id}' />
	<input class='button' type="submit" value='Delete' />
	</form>
	</td>
	{/if}
	</tr>
	{/section}
{else}
	{section name=shouts_loop loop=$shouts}
	<tr class='shout_div0' >
    {assign var='action_date' value=$datetime->time_since($shouts[shouts_loop].shout_time)}
	<td class='shout_pic'><a href='{$shouts[shouts_loop].profile_page}'>{$shouts[shouts_loop].displayname}</a></td><td class='shout_msg'>{$shouts[shouts_loop].shout_msg}</td><td class='shout_ago'><span class='shout_ago2'>{lang_sprintf id=$action_date[0] 1=$action_date[1]}</span></td>
	{if $shout_moderator == 1}
	<td>
	<form action="user_shoutbox_history.php" method="post">
	<input type="hidden" name='task' value='delete_shout' />
	<input type="hidden" name='shout_id' value='{$shouts[shouts_loop].shout_id}' />
	<input class='button' type="submit" value='Delete' />
	</form>
	</td>
	{/if}
	</tr>
	{/section}
{/if}
</table>





{* DISPLAY PAGINATION MENU IF APPLICABLE *}
{if $maxpage > 1}
  <div class='center'>
  {if $p != 1}<a href='user_shoutbox_history.php?p={math equation='p-1' p=$p}'>&#171; {lang_print id=182}</a>{else}<font class='disabled'>&#171; {lang_print id=182}</font>{/if}
  {if $p_start == $p_end}
    &nbsp;|&nbsp; {lang_sprintf id=184 1=$p_start 2=$total_pms} &nbsp;|&nbsp; 
  {else}
    &nbsp;|&nbsp; {lang_sprintf id=185 1=$p_start 2=$p_end 3=$total_pms} &nbsp;|&nbsp; 
  {/if}
  {if $p != $maxpage}<a href='user_shoutbox_history.php?p={math equation='p+1' p=$p}'>{lang_print id=183} &#187;</a>{else}<font class='disabled'>{lang_print id=183} &#187;</font>{/if}
  </div>
<br>
{/if}

{include file='footer.tpl'}