<?php
$page = "user_shoutbox_history";
include "header.php";

function shout_hyperlink(&$text) {
      $text = preg_replace('@((https?:)?//([-\w\.]+)+(:\d+)?(/([\w/_\.]*(\?\S+)?)?)?)@', '<a href="$1" target="_blank">$1</a>', $text);
   
      $text = preg_replace("/\s(www\.([a-z][a-z0-9_\..-]*[a-z]{2,6})([a-zA-Z0-9\/*-?&%]*))\s/i", " <a href=\"http://$1\" target=\"_blank\">$1</a> ", $text);
      $text = preg_replace("/^(www\.([a-z][a-z0-9_\..-]*[a-z]{2,6})([a-zA-Z0-9\/*-?&%]*))\s/i", "<a href=\"http://$1\" target=\"_blank\">$1</a> ", $text);
      $text = preg_replace("/\s(www\.([a-z][a-z0-9_\..-]*[a-z]{2,6})([a-zA-Z0-9\/*-?&%]*))$/i", " <a href=\"http://$1\" target=\"_blank\">$1</a>", $text);
      $text = preg_replace("/^(www\.([a-z][a-z0-9_\..-]*[a-z]{2,6})([a-zA-Z0-9\/*-?&%]*))$/i", "<a href=\"http://$1\" target=\"_blank\">$1</a>", $text);
     
      return $text;
}

if(isset($_POST['p'])) { $p = $_POST['p']; } elseif(isset($_GET['p'])) { $p = $_GET['p']; } else { $p = 1; }
if(isset($_POST['task'])) { $task = $_POST['task']; } elseif(isset($_GET['task'])) { $task = $_GET['task']; } else { $task = ''; }

// SET VARS
$shouts_per_page = 20;

// GET SHOUTBOX SETTINGS	
$shoutbox_settings = $database->database_fetch_assoc($database->database_query("SELECT * FROM se_shout_settings LIMIT 1"));

// USER IS LOGGED IN
$serve_shouts=0;
if($user->user_exists != 0) $serve_shouts=1;
if ($shoutbox_settings['shout_setting_shouts_public'] == 1) $serve_shouts=1;

if($serve_shouts != 0) { 	

	$moderators = explode(",",$shoutbox_settings['shout_setting_moderators']);
	if (sizeof($moderators) > 0) foreach ($moderators as &$d) $d = trim($d);
	if (in_array($user->user_info['user_username'],$moderators)) {
		$shout_moderator=1;
	} else {
		$shout_moderator=0;
	}
	
	if ($shout_moderator == 1 && $task=='delete_shout' ) {
		if(isset($_POST['shout_id'])) { $shout_id = $_POST['shout_id']; } elseif(isset($_GET['shout_id'])) { $shout_id = $_GET['shout_id']; } else { $shout_id = ''; }
		$database->database_query("DELETE FROM se_shouts WHERE shout_id='".$shout_id."' LIMIT 1");
	}

	$user_settings = $database->database_fetch_assoc($database->database_query("SELECT * FROM se_usersettings WHERE usersetting_user_id='".$user->user_info[user_id]."' LIMIT 1"));

	// Add new message, if posted
	$action = $_REQUEST['action'];
	$message = censor(strip_tags($_REQUEST['shoutbox_msg']));
	// HTML encode
	$message = htmlspecialchars($message, ENT_QUOTES);
	
	$userID = $user->user_info[user_id];
	$timeNow = time();
	// Flood check
	$lastShoutThisUser = $database->database_fetch_assoc($database->database_query("SELECT shout_time FROM se_shouts WHERE shout_user_id='$userID' ORDER BY shout_time DESC LIMIT 1"));
	if ($action === "postmsg") {
		if (strlen($message) >= $shoutbox_settings['shout_setting_min_msg_length']) {
			if ($timeNow - $lastShoutThisUser['shout_time'] > $shoutbox_settings['shout_setting_flood_time']) {
				// Insert shout
				$database->database_query("INSERT INTO se_shouts SET shout_user_id='$userID', shout_msg='$message', shout_time='$timeNow'");
			}
		} 
		$shoutAllowed = 0;
		$timeToNextShout = $shoutbox_settings['shout_setting_flood_time'];
	} else {
		$timeToNextShout = $shoutbox_settings['shout_setting_flood_time'] - ($timeNow - $lastShoutThisUser['shout_time']);
		if ($timeToNextShout >= 0) {
			$shoutAllowed = 0;
		} else {
			$shoutAllowed = 1;	
		}
	}
		
	$total_shouts_assoc = $database->database_fetch_assoc($database->database_query("SELECT COUNT(*) AS total_shouts FROM se_shouts"));
	$total_shouts = $total_shouts_assoc['total_shouts'];
		
	$maxShouts = $shouts_per_page;
	$offset = ($p - 1) * $shouts_per_page;
		
	$filterSetting = $user_settings['usersetting_shoutbox_filter'];
				
	if ($filterSetting == 0) {  // All shouts
		$newShoutsQueryResult = $database->database_query("SELECT se_shouts.shout_id, se_shouts.shout_user_id,se_shouts.shout_msg,se_shouts.shout_time,se_users.user_username, se_users.user_fname,se_users.user_lname, se_users.user_photo FROM se_shouts JOIN se_users ON se_shouts.shout_user_id=se_users.user_id ORDER BY shout_id DESC LIMIT $maxShouts OFFSET $offset");
	} else if ($filterSetting == 1) {  // Only friends shouts
		$newShoutsQueryResult = $database->database_query("SELECT s1.shout_id, s1.shout_user_id,s1.shout_msg,s1.shout_time,se_users.user_username, se_users.user_fname,se_users.user_lname, se_users.user_photo FROM se_shouts s1 JOIN se_users ON s1.shout_user_id=se_users.user_id WHERE (EXISTS (SELECT * FROM se_friends WHERE friend_user_id1='".$user->user_info[user_id]."' AND friend_user_id2=s1.shout_user_id) OR s1.shout_user_id='".$user->user_info[user_id]."') ORDER BY s1.shout_id DESC LIMIT $maxShouts OFFSET $offset");	
	}
	$newShouts = array();
	while ($newShout = $database->database_fetch_assoc($newShoutsQueryResult)) {
		$newShouts[] = $newShout;
	}
	
	$newShouts = array_reverse($newShouts);
	$newTimeStamp = time();

	$shouts_arr = array();
	if (sizeof($newShouts) > 0) foreach ($newShouts as $shout) {
		$shout['timeStamp'] = $newTimeStamp;

		$fullname = $shout['user_fname'].((trim($shout['user_fname']) != "" && trim($shout['user_lname']) != "") ? " " : "").$shout['user_lname'];
		$user_displayname = (trim($fullname) != "") ? $fullname : $shout['user_username'];

		if ($setting['setting_username'] == 1) {
			$profile_page = "profile.php?user=".$shout['user_username'];
		} else {		
			$profile_page = "/".$shout['user_username'];
		}
		$shout['profile_page'] = $profile_page;
		$shout['displayname'] = shout_truncate($user_displayname,20,'...');
		
		$photo_arr = explode(".",$shout['user_photo']);
		$photo_ext = array_pop($photo_arr);
		$photo_thumb = implode(".",$photo_arr)."_thumb.".$photo_ext;
		$subdir = $shout['shout_user_id']+999-(($shout['shout_user_id']-1)%1000);
	    $userdir = "./uploads_user/$subdir/".$shout['shout_user_id']."/";
		if (strlen($shout['user_photo']) == 0) {
			$shout['profile_pic'] =  "images/nophoto.gif";
		} else {
			$shout['profile_pic'] =  $userdir.$photo_thumb;		
		}
		$shout['shout_msg'] = htmlspecialchars_decode($shout['shout_msg'], ENT_QUOTES);
		$shout['shout_msg'] = shout_hyperlink($shout['shout_msg']);
		$shouts_arr[]=$shout;
	}

} 

// MAKE SHOUT PAGES
$page_vars = make_page($total_shouts, $shouts_per_page, $p);

// ASSIGN VARIABLES AND INCLUDE FOOTER
$smarty->assign('total_shouts', $total_shouts);
$smarty->assign_by_ref('shouts', array_reverse($shouts_arr));
$smarty->assign_by_ref('shoutUserPhoto', $shoutbox_settings['shout_setting_user_photo']);
$smarty->assign('shout_allowed', $shoutAllowed);
$smarty->assign('shout_time2next', $timeToNextShout);

$smarty->assign('p', $page_vars[1]);
$smarty->assign('maxpage', $page_vars[2]);
$smarty->assign('p_start', $page_vars[0]+1);
$smarty->assign('p_end', $page_vars[0]+count($shouts_arr));
	
$smarty->assign('shout_moderator', $shout_moderator);
include "footer.php";
?>
